<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

include('config.php');

$input = json_decode(file_get_contents("php://input"), true);
$email = $input['email'] ?? null;

if (!$email) {
    echo json_encode(['success'=>false,'message'=>'IB email is required']);
    exit;
}

// Update commission_status to 0 (stopped)
$stmt = $conn->prepare("UPDATE loginusers SET commission_status = 0 WHERE email = ?");
$stmt->bind_param("s", $email);
if ($stmt->execute()) {
    echo json_encode(['success'=>true,'message'=>'IB commission stopped successfully']);
} else {
    echo json_encode(['success'=>false,'message'=>'Failed to stop IB commission']);
}
$stmt->close();
?>
